/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.blocks.akashic;

import at.petrak.hexcasting.api.misc.TriPredicate;
import java.util.ArrayDeque;
import java.util.HashSet;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public interface AkashicFloodfiller {
    default public boolean canBeFloodedThrough(class_2338 pos, class_2680 state, class_1937 world) {
        return true;
    }

    @Nullable
    public static class_2338 floodFillFor(class_2338 start, class_1937 world, TriPredicate<class_2338, class_2680, class_1937> isTarget) {
        return AkashicFloodfiller.floodFillFor(start, world, 0.0f, isTarget, 128);
    }

    @Nullable
    public static class_2338 floodFillFor(class_2338 start, class_1937 world, float skipChance, TriPredicate<class_2338, class_2680, class_1937> isTarget, int maxRange) {
        HashSet<class_2338> seenBlocks = new HashSet<class_2338>();
        ArrayDeque<class_2338> todo = new ArrayDeque<class_2338>();
        todo.add(start);
        HashSet<class_2338> skippedBlocks = new HashSet<class_2338>();
        while (!todo.isEmpty()) {
            class_2338 here = (class_2338)todo.remove();
            for (class_2350 dir : class_2350.values()) {
                class_2338 neighbor = here.method_10093(dir);
                if (neighbor.method_10262((class_2382)start) > (double)(maxRange * maxRange) || !seenBlocks.add(neighbor)) continue;
                class_2680 bs = world.method_8320(neighbor);
                if (isTarget.test(neighbor, bs, world)) {
                    if (world.field_9229.method_43057() > skipChance) {
                        return neighbor;
                    }
                    skippedBlocks.add(neighbor);
                }
                if (!AkashicFloodfiller.canItBeFloodedThrough(neighbor, bs, world)) continue;
                todo.add(neighbor);
            }
        }
        if (!skippedBlocks.isEmpty()) {
            return (class_2338)skippedBlocks.iterator().next();
        }
        return null;
    }

    public static boolean canItBeFloodedThrough(class_2338 pos, class_2680 state, class_1937 world) {
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof AkashicFloodfiller)) {
            return false;
        }
        AkashicFloodfiller flooder = (AkashicFloodfiller)class_22482;
        return flooder.canBeFloodedThrough(pos, state, world);
    }
}

